#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//prison sphereMod01.fsh   by  jorge2017a2   
//https://www.shadertoy.com/view/fdBcRD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//----------image
//por jorge2017a1-
#define MAX_STEPS 100
#define MAX_DIST 100.
#define MIN_DIST 0.001
#define EPSILON 0.001
#define REFLECT 2
//-----Start Common----//
//----------common
struct TObj
{
    float id_color;
    float id_objeto;
    float id_material;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 phit; //22-mar-2021
    vec3 rf;
    float marchCount;
    bool blnShadow;
    bool hitbln;
};

    
TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;

#define PI 3.14159265358979323846264
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0
#define COLORSKY vec3(0.1, 0.1, 0.6)


///Gracias a SHane...16-jun-2020
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
    n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
    n /= dot(n, vec3(1)); 
    vec3 tx = texture2D(tex, p.yz).xyz;
    vec3 ty = texture2D(tex, p.zx).xyz;
    vec3 tz = texture2D(tex, p.xy).xyz;
    return mat3(tx*tx, ty*ty, tz*tz)*n; 
}

vec3  Arrcolores[] = vec3[] (
vec3(0,0,0),  //0
vec3(1.,1.,1.), //1
vec3(1,0,0),  //2
vec3(0,1,0),   //3
vec3(0,0,1),   //4
vec3(1,1,0),  //5
vec3(0,1,1),  //6 
vec3(1,0,1),   //7
vec3(0.7529,0.7529,0.7529),  //8
vec3(0.5,0.5,0.5),  //9
vec3(0.5,0,0),   //10
vec3(0.5,0.5,0.0),  //11
vec3(0,0.5,0),   //12
vec3(0.5,0,0.5),  //13
vec3(0,0.5,0.5),  //14
vec3(0,0,0.5),    //15
vec3(1.0, 0.8, 0.737),  //16
vec3(0.8, 0.8, 0.8),  //17
vec3(0.5, 0.5, 0.8),  //18
vec3(1, 0.5, 0),      //19
vec3(1.0, 1.0, 1.0),  //20
vec3(0.968,0.6588,  0.721),  //21
vec3(0, 1, 1),                           //22 
vec3(0.333, 0.803, 0.988),    //23
vec3(0.425, 0.56, 0.9)*vec3( 0.3, 0.2, 1.0 ),  //24 
vec3(0.8,0.8,0.8)*vec3( 0.3, 0.2, 1.0 ),       //25  
vec3(1.0,0.01,0.01)*vec3( 0.3, 0.2, 1.0 ),     //26
vec3(0.1, 0.5, 1.0),                           //27   
vec3(0.0, 0.6, 0.0),                       //28 
vec3(0.1,0.1,0.7),                          //29
vec3(0.99, 0.2, 0.1), //30
vec3(.395, .95, 1.), //31
vec3(0.425, 0.56, 0.9) 
);

vec3 getColor(int i)
{    
    if (i==-2 ) {return mObj.color; }       
    if (i>-1 ) 
		return Arrcolores[i];
}


//---end Common---///

vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);
vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )
#define opU(d1, d2) ( d1.x < d2.x ? d1 : d2 )

float sdSphere( vec3 p, float s )
	{ return length(p)-s;}
float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }

///----------Operacion de Distancia--------
float intersectSDF(float distA, float distB)
	{ return max(distA, distB);}
float unionSDF(float distA, float distB)
	{ return min(distA, distB);}
float differenceSDF(float distA, float distB)
	{ return max(distA, -distB);}
//----------oPeraciones de Repeticion
float opRep1D( float p, float c )
	{ float q = mod(p+0.5*c,c)-0.5*c; return  q ;}
vec3 rotate_y(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}

float tau = atan(1.0) * 8.0;
vec3 opAngRep( vec3 p, float a )
{   vec2 polar = vec2(atan(p.y, p.x), length(p.xy));
    polar.x = mod(polar.x + a / 2.0, a) - a / 2.0;
    return vec3(polar.y * vec2(cos(polar.x),sin(polar.x)), p.z);
}

vec3 opAngRepFull( vec3 p, float numItem )
{   return opAngRep(p, tau / numItem); }

vec3 Paredes2(vec3 p, vec3 p0a, float ancho)
{   vec3 res= vec3(9999.0, -1.0,-1.0);  vec3 p0=p;
    vec3 prep= opAngRepFull(p,9.0 );
    float d1= sdBox(prep, vec3(ancho+2.0,0.2,ancho+3.0));
    float d2=sdSphere(p0a-vec3(0.0,3.0,0.0), ancho );
    float d3=sdSphere(p0a-vec3(0.0,3.0,0.0), ancho-2.0 );
    float d4=sdSphere(p0a-vec3(0.0,3.0,0.0), ancho+3.0 );
    float dif=differenceSDF(d2, d3);
    dif=differenceSDF(d1,dif);
    dif=intersectSDF(dif,d4);
    dif=differenceSDF(dif,d2);
    //res =opU3(res, vec3(dif,1.0,-1.0));
    res =opU3(res, vec3(dif,100.0,-1.0));
    return res;
}

vec3 EsferaFull(vec3 p,  float ancho)
{   vec3 res= vec3(9999.0, -1.0,-1.0);  vec3 p0=p;
    float d1=sdSphere(p-vec3(0.0,5.0,0.0), ancho );
    float d2=sdSphere(p-vec3(0.0,5.0,0.0), ancho-2.0 );
    p.y= opRep1D(p.y,2.0 );
    float d3=sdBox( p, vec3(ancho,0.5,ancho) );
    float dif= differenceSDF(d1, d2);
    dif= differenceSDF(dif, d3);
    res =opU3(res, vec3(dif,2.0,-1.0));
    vec3 pr2= Paredes2(p0.zxy-vec3(0.0,0.0,0.0),p0, ancho);
    res =opU3(res, pr2);
    return res;
}

vec3 GetDist(vec3 p  ) 
{	vec3 res= vec3(9999.0, -1.0,-1.0);  vec3 p0=p;
	float planeDist1 = p.y+0.0;  //piso inf
    float ancho=15.0;
    p= rotate_y(p,radians(iTime*10.0));
    mObj.phit=p;
    vec3 e1= EsferaFull(p,ancho);
    ancho=35.0;
    p= rotate_y(p0,radians(-iTime*20.0));
    vec3 e2= EsferaFull(p,ancho);
    res =opU3(res, e1);
    res =opU3(res, e2);
    return res;
}

vec3 GetNormal(vec3 p)
{   float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(GetDist(p-e.xyy).x,GetDist(p-e.yxy).x,GetDist(p-e.yyx).x);
    return normalize(n);
}

float RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{   vec3 dS=vec3(9999.0,-1.0,-1.0);
    float marchCount = 0.0;
    vec3 p;
    float minDist = 9999.0 ,t = 0.; 
    
    for(int i=0; i <= PMaxSteps; i++) 
    {  	p = ro + rd*t;
        dS = GetDist(p);
        t += dS.x;
        if ( abs(dS.x)<MIN_DIST  || i == PMaxSteps)
            {mObj.hitbln = true; minDist = abs(t); break;}
        if(t>MAX_DIST)
            {mObj.hitbln = false;    minDist = t;    break; } 
        marchCount++;
    }
    mObj.dist = minDist;
    mObj.id_color = dS.y;
    mObj.marchCount=marchCount;
    mObj.id_material=dS.z;
    mObj.normal=GetNormal(p);
    mObj.phit=p;
    return t;
}

float occlusion(vec3 pos, vec3 nor)
{   float sca = 2.0, occ = 0.0;
    for(int i = 0; i < 10; i++) {    
        float hr = 0.01 + float(i) * 0.5 / 4.0;        
        float dd = GetDist(nor * hr + pos).x;
        occ += (hr - dd)*sca;
        sca *= 0.6;
    }
    return clamp( 1.0 - occ, 0.0, 1.0 );    
}

vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro,vec3 col, float t) 
{   vec3 lightPos=lp;
    vec3 hit = ro + rd * t;
    vec3 norm = GetNormal(hit);
    
    vec3 light = lightPos - hit;
    float lightDist = max(length(light), .001);
    float atten = 1. / (1.0 + lightDist * 0.125 + lightDist * lightDist * .05);
    light /= lightDist;
    
    float occ = occlusion(hit, norm);
      float dif = clamp(dot(norm, light), 0.0, 1.0);
    dif = pow(dif, 4.) * 2.;
    float spe = pow(max(dot(reflect(-light, norm), -rd), 0.), 8.);
    vec3 color = col*(dif+.35 +vec3(.35,.45,.5)*spe) + vec3(.7,.9,1)*spe*spe;
    color*=occ;
    return color;
}

vec3 getColorTextura( vec3 p, vec3 nor,  int i)
{	if (i==100 )
    {   
        vec3 ptmp=mObj.phit;
        p= rotate_y(ptmp,radians(iTime*10.0));
        nor= rotate_y(nor,radians(iTime*10.0));
        //p= ptmp;
        vec3 col=tex3D(texture0, p/16., nor); return col*2.0; 
    }
}

vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos, float tdist)
{  float intensity=1.0;
     vec3 result;
    result = lightingv3( nor, p, plight_pos,  rd,ro, colobj, tdist);
    return result;
}

vec3 render_sky_color(vec3 rd)
{   float t = (rd.x + 1.0) / 2.0;
    vec3 col= vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
    vec3  sky = mix(vec3(.0, .1, .4)*col, vec3(.3, .6, .8), 1.0 - rd.y);
	return sky;
}

vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{  	vec3 colobj; 
    
    if( mObj.hitbln==false) return  render_sky_color(rd);
    
    if (id_color<100)
		{ colobj=getColor(int( id_color)); }
    
    if ( float( id_color)>=100.0  && float( id_color)<=199.0 ) 
 	{  vec3 coltex=getColorTextura(p, n, int( id_color)); colobj=coltex; }
    return colobj;
}

vec3 Render(vec3 ro, vec3 rd)
{  vec3 col = vec3(0);
   TObj Obj;
   mObj.rd=rd; mObj.ro=ro;
   vec3 p;
     float d=RayMarch(ro,rd, MAX_STEPS);
   
    Obj=mObj;
    if(mObj.hitbln) 
    {   p = (ro + rd * d );  
        vec3 nor=mObj.normal;
        vec3 colobj;
        colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);

        float dif1=1.0;
        vec3 result;
        result=  Getluz( p,ro,rd, nor, colobj ,light_pos1,d)*light_color1;
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2,d)*light_color2;
   
        col= result;
        //col= (ACESFilm(col)+linear2srgb(col)+col+ exposureToneMapping(3.0, col))/4.0 ;
    }
    else if(d>MAX_DIST)
    col= render_sky_color(rd);
   return col;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{     vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
   mObj.uv=uv;
    float t;
    t=mod(iTime*1.0,360.0);
    itime=t;
	//mObj.blnShadow=false;
    mObj.blnShadow=true;

 	light_pos1= vec3(-10.0, 20.0, -10.0 ); light_color1=vec3( 1.0,1.0,1.0 );
 	light_pos2= vec3(10.0, 10.0, -10.0 ); light_color2 =vec3( 1.0,1.0,1.0 ); 
   vec3 ro=vec3(0.0,7.0+8.0*sin(t),-30.0+2.5*cos(t));
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));

    vec3 col= Render( ro,  rd);
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

